package com.ejie.ab04b.dao.custom;

import java.util.List;

import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.dao.TareaDao;
import com.ejie.ab04b.model.Tarea;
import com.ejie.x38.dto.JQGridRequestDto;

/**
 * TramiteAperturasDao generated by UDA, 02-Feb-2017 13:49:16.
 * 
 * @author UDA
 */

public interface TareaCustomDao extends TareaDao {

	/**
	 * Finds a single row in the Tarea table.
	 * 
	 *  tarea
	 *            Tarea
	 *  Tarea
	 *
	 * @param tarea the tarea
	 * @return the tarea
	 */
	@Transactional(readOnly = true)
	public Tarea vfind(Tarea tarea);

	/**
	 * Finds a single row in the Tarea table.
	 * 
	 *  taskId
	 *            String
	 *  procedureId
	 *            String
	 *  Tarea
	 *
	 * @param taskId the task id
	 * @param procedureId the procedure id
	 * @return the tarea
	 */
	@Transactional(readOnly = true)
	public Tarea findByTaskIdProcedureId(String taskId, String procedureId);

	/**
	 * Finds a list of rows in the Tarea table.
	 * 
	 *  tarea
	 *            Tarea
	 *  jqGridRequestDto
	 *            JQGridRequestDto
	 *  List<Tarea>
	 *
	 * @param tarea the tarea
	 * @param jqGridRequestDto the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<Tarea> vfindAll(Tarea tarea, JQGridRequestDto jqGridRequestDto);

}
